define(['app', 'angular'], function (app, angular) {

	app.directive('inputGroupRadio', function () {
		return {
			restrict: 'E',
			require: 'ngModel',
			scope: {
				'label': '@',
				'name': '@',
				'ngDisabled': '=',
				'ngRequired': '=',
				'ngModel': '='
			},
			link: function(scope, elems, attrs, ngModelCtrl){
				if(scope.ngRequired) {

	                var validator = function(newVal) {
                		ngModelCtrl.$setValidity("selectionMade", !!newVal.selectedValue);
	                	return newVal;
	                };

					scope.onChange = function() {
						validator(scope.ngModel);
					};

	                ngModelCtrl.$parsers.push(validator);
	                ngModelCtrl.$formatters.push(validator);
				}
			},
			templateUrl: 'src/ui-components/form/controls/simple/input-group-radio/input-group-radio_template.html'
		};
	});

});